package gov.va.med.mhv.common.props.model;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Version;

@Entity
@Table(name = "COMPONENT_PROPERTIES")
public class ComponentProperty {
	
	@Id
	@Column(name = "COMPONENT_PROPERTY_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;
	
	@Column(name="COMPONENT_NAME", length=128, nullable=false)
	private String componentName;

	@Column(name="PROPERTY_KEY", length=512, nullable=false)
	private String key;
	
	@Column(name="PROPERTY_VALUE", length=4000, nullable=false)
	private String value;
	
	@Column(name="CREATED_DATE", updatable=false)
	private Date createdDate;
	
	@Version
	@Column(name="LAST_UPDATED")
	private Date lastUpdateDate;
	
	@Column(name="PROPERTY_INFO", nullable=true)
	private String propertyInfo;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getComponentName() {
		return componentName;
	}

	public void setComponentName(String componentName) {
		this.componentName = componentName;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public Date getLastUpdateDate() {
		return lastUpdateDate;
	}

	public void setLastUpdateDate(Date lastUpdateDate) {
		this.lastUpdateDate = lastUpdateDate;
	}

	public String getPropertyInfo() {
		return propertyInfo;
	}

	public void setPropertyInfo(String propertyInfo) {
		this.propertyInfo = propertyInfo;
	}

}
